package gov.va.med.mhv.bluebutton.repository;

import gov.va.med.mhv.bluebutton.model.StudyJob;

import java.sql.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface StudyJobRepository extends JpaRepository<StudyJob, Long>{
	
	/**
	 * @param patientId
	 * @return
	 * retrievePhrStudyJobs
	 */
	@Query("select studyJob from StudyJob studyJob where "
									+ "studyJob.patientId = :patientId")
	List <StudyJob> getPhrStudyJobs(@Param("patientId") Long patientId
									);
	
	/**
	 * @param patientId
	 * @param studyId
	 * @return
	 * retrievePhrStudyJob
	 */
	@Query("select studyJob from StudyJob studyJob where "
									+ "studyJob.patientId = :patientId and "
									+ "studyJob.studyIdUrn=:studyIdUrn")
	List <StudyJob> getPhrStudyJob(@Param("patientId") Long patientId,
									@Param("studyIdUrn") String studyIdUrn
									);
	
	/**
	 * @param status
	 * @return
	 * retrievePhrStudyJobByStatus
	 */
	@Query("select studyJob from StudyJob studyJob where "
									+ "studyJob.status = :status and "
									+ "studyJob.serverNode=:serverNode"	
									)
	List <StudyJob> getPhrStudyJobsByStatus(@Param("status") String status,
											@Param("serverNode") String serverNode
											);
	
	
	/**
	 * @param status
	 * @return
	 * retrievePhrStudyCountByStatus
	 */
	@Query("select count(studyJob) from StudyJob studyJob where "
									+ "studyJob.patientId = :patientId and "
									+ "studyJob.status = :status")
	int getPhrStudyJobCountByStatus(@Param("patientId") Long patientId,
									@Param("status") String status);
	
	
	@Procedure("BBMI_DOWNLOAD_REMINDER")
	public void bbmiDownloadReminder(Long patientId, Long patientStatusJobId);
	
	
}

